--
-- file prepared: 15 May 2024 23:18:38.600, using fd633c
--

--
-- M2 round 1 (12.7)
--
declare_weapon({category = CAT_SHELLS,name = "M2_12_7_T",
  user_name		= _("M2_12_7_T"),
  model_name    = "tracer_bullet_red",

  v0    = 930.0,
  Dv0   = 0.0060,
  Da0     = 0.0005,
  Da1     = 0.0,
  mass      = 0.046,
  round_mass = 0.145,
  explosive     = 0.0000,
  life_time     = 7,
  caliber     = 12.7,
  s         = 0.0,
  j         = 0.0,
  l         = 0.0,
  charTime    = 0,
  cx        = {1.0,0.62,0.65,0.175,1.80},
  k1        = 1.5e-08,
  tracer_off    = 4,
  scale_tracer  = 1,

  name = "12.7",
  
  cartridge = 0,

  
})

--
-- M2 round 2 (12.7)
--
declare_weapon({category = CAT_SHELLS, name = "Utes_12_7x108",
  user_name		= _("Utes_12_7x108"),
  model_name    = "tracer_bullet_green",
 
  v0    = 840.0,
  Dv0   = 0.0082,
  Da0     = 0.00085,
  Da1     = 0.0,
  mass      = 0.047,
  round_mass = 0.130,
  explosive     = 0.0000,
  life_time     = 7,
  caliber     = 12.7,
  s         = 0.0,
  j         = 0.0,
  l         = 0.0,
  charTime    = 0,
  cx        = {0.5,0.61,0.8,0.27,1.9},
  k1        = 1.2e-08,
  tracer_off    = 4,
  scale_tracer  = 1,

  name = "12.7",
  
  cartridge = 0,

})

--
-- M2 cannon
--
function M_2(tbl)

	tbl.category = CAT_GUN_MOUNT 
	tbl.name 	 = "M_2"
	tbl.supply 	 =
	{
		shells = {"M2_12_7_T", "Utes_12_7x108" },
		mixes  = {{1,1,2,1,2}},
		count  = 1800,		--unsure of actual count, p40 has 6xcannon, so assuming 300 rounds each  --1800 rounds for f80	  -- Ho 103 (1000)	
	}
	if tbl.mixes then 
	   tbl.supply.mixes =  tbl.mixes
	   tbl.mixes	    = nil
	end
	tbl.gun = 
	{
		max_burst_length = 25,
		rates 			 = {1200},		--p40 (1200)  --f80  (1200)  -- Ho 103 (983)
		recoil_coeff 	 = 0.2*1.3,
		barrels_count 	 = 1,
	}
	if tbl.rates then 
	   tbl.gun.rates    =  tbl.rates
	   tbl.rates	    = nil
	end	
	tbl.ejector_pos 			= tbl.ejector_pos or {-0.4, -1.2, 0.18}
	tbl.ejector_dir 			= {0,-1,0}
	tbl.supply_position  		= tbl.supply_position   or {0,  0.3, -0.3}
	tbl.aft_gun_mount 			= false
	tbl.effective_fire_distance = 1500
	tbl.drop_cartridge 			= 0
	tbl.muzzle_pos				= tbl.muzzle_pos 		 or  {0,0,0} -- all position from connector
	tbl.muzzle_pos_connector	= tbl.muzzle_pos_connector 		 or  "Gun_point" -- all position from connector
	tbl.azimuth_initial 		= tbl.azimuth_initial    or 0   
	tbl.elevation_initial 		= tbl.elevation_initial  or 0   
	if  tbl.effects == nil then
		tbl.effects = {{ name = "FireEffect"     , arg 		 = tbl.effect_arg_number or 436 },
					   { name = "HeatEffectExt"  , shot_heat = 7.823, barrel_k = 0.462 * 2.7, body_k = 0.462 * 14.3 },
					   { name = "SmokeEffect"}}
	end
	return declare_weapon(tbl)
end


--
--	note: the above is modelled after the example for the GSHG_7_62 cannon as found in Scripts\Database\Weapons\aircraft_gun_mounts.lua, and
--  the example for the M2_12_7_T, and Utes_12_7x108 rounds as found in Scripts\Database\Weapons\shell_table.lua
--



